/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.util;

import com.ibm.hwmca.fw.rcs.RcsObject;
import com.ibm.hwmca.fw.rcs.util.RcsException;
import com.ibm.hwmca.fw.rcs.util.RcsTrace;
import com.ibm.hwmca.fw.util.RootProcess;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class RcsPppControl
extends RcsObject {
    public static final int PPP_SUCCESS = 0;
    public static final int PPP_ERROR_FATAL_ERROR = 1;
    public static final int PPP_ERROR_BAD_OPTIONS = 2;
    public static final int PPP_ERROR_NOT_ROOT = 3;
    public static final int PPP_ERROR_NO_KERNEL = 4;
    public static final int PPP_ERROR_TERMINATED = 5;
    public static final int PPP_ERROR_UNABLE_TO_LOCK = 6;
    public static final int PPP_ERROR_UNABLE_TO_OPEN = 7;
    public static final int PPP_ERROR_CONNECT_FAILED = 8;
    public static final int PPP_ERROR_PTY_COMMAND_FAILED = 9;
    public static final int PPP_ERROR_NEGOTIATION_FAILED = 10;
    public static final int PPP_ERROR_PEER_FAILED_AUTH = 11;
    public static final int PPP_ERROR_CONNECTION_IDLE = 12;
    public static final int PPP_ERROR_CONNECTION_LIMIT = 13;
    public static final int PPP_ERROR_CALLBACK_INITIATED = 14;
    public static final int PPP_ERROR_UNABLE_TO_ECHO = 15;
    public static final int PPP_ERROR_MODEM_HANGUP = 16;
    public static final int PPP_ERROR_SERIAL_LOOPBACK = 17;
    public static final int PPP_ERROR_INIT_FAILED = 18;
    public static final int PPP_ERROR_FAILED_AUTH = 19;
    public static final int PPP_ERROR_FAILED_TO_EXEC = 200;
    public static final int PPP_ERROR_DIED_FROM_SIGNAL = 201;
    public static final int PPP_ERROR_TIMEOUT = 300;
    public static final int AUTH_CHAP = 0;
    public static final int AUTH_PAP = 1;
    private static final int ID_MAX_INSTANCES = 99;
    private static final String ID_PREFIX = "RcsPppLink";
    private static Set sUniqueIds = new HashSet();
    private static final int PPP_TIMEOUT = 300000;
    private boolean cPppActive = false;
    private Object cPppLock = new Object();
    private Process cPppProcess = null;
    private int cPppRc;
    private BufferedReader cPppOut;
    private BufferedReader cPppErr;
    private String cLinkname;
    private int cAuthType;
    private String cUsername;
    private String cPassword;
    private String cOptions;

    private static synchronized String getUniqueId() throws RcsException {
        for (int i = 0; i < 99; ++i) {
            String mId = ID_PREFIX + i;
            if (sUniqueIds.contains(mId)) continue;
            sUniqueIds.add(mId);
            RcsTrace.ttrace("RcsPppControl <-> getUniqueId() [" + mId + "]");
            return mId;
        }
        throw new RcsException("All unique instances have been exhausted, this is bad.");
    }

    private static synchronized void removeUniqueId(String pId) {
        sUniqueIds.remove(pId);
    }

    public RcsPppControl(String pUsername, String pPassword, String pOptions) {
        this(0, pUsername, pPassword, pOptions);
    }

    public RcsPppControl(int pAuthType, String pUsername, String pPassword, String pOptions) {
        this.setAuthType(pAuthType);
        this.setUsername(pUsername);
        this.setPassword(pPassword);
        this.setOptions(pOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws RcsException {
        this.ttrace("--> start()");
        int mRc = 0;
        Object object = this.cPppLock;
        synchronized (object) {
            block10: {
                if (this.cPppActive) {
                    return 0;
                }
                if (this.cPppProcess != null) {
                    throw new RcsException("Ppp is already in the process of connecting.");
                }
                this.cLinkname = RcsPppControl.getUniqueId();
                try {
                    String mModemDevice = "/dev/modem";
                    String mProgram = "rcsPppControl" + (this.cAuthType == 1 ? " --pap" : " --chap") + " " + this.cUsername + " " + this.cPassword + " " + mModemDevice + " 38400" + " user " + this.cUsername + " linkname " + this.cLinkname + " updetach" + " " + this.cOptions;
                    this.dtrace("Attempting to launch: " + mProgram);
                    this.cPppProcess = RootProcess.startProgram(mProgram);
                    this.cPppOut = new BufferedReader(new InputStreamReader(this.cPppProcess.getInputStream()));
                    this.cPppErr = new BufferedReader(new InputStreamReader(this.cPppProcess.getErrorStream()));
                    new Thread("RcsPppControl.start()"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            while (RcsPppControl.this.cPppProcess != null) {
                                try {
                                    RcsPppControl.this.cPppRc = RcsPppControl.this.cPppProcess.waitFor();
                                    RcsPppControl.this.cPppProcess = null;
                                }
                                catch (InterruptedException e) {
                                    RcsPppControl.this.ttrace("PPP Process interrupted: " + e);
                                }
                            }
                            Object object = RcsPppControl.this.cPppLock;
                            synchronized (object) {
                                RcsPppControl.this.ftrace("PPP Process finished with rc: " + RcsPppControl.this.cPppRc);
                                if (RcsPppControl.this.cPppRc == 0) {
                                    RcsPppControl.this.cPppActive = true;
                                } else {
                                    RcsPppControl.removeUniqueId(RcsPppControl.this.cLinkname);
                                }
                                RcsPppControl.this.cPppLock.notifyAll();
                            }
                        }
                    }.start();
                    long timestamp = System.currentTimeMillis();
                    do {
                        try {
                            this.cPppLock.wait(300000L);
                        }
                        catch (InterruptedException e) {
                            this.ftrace("start thread was interrupted: " + e);
                        }
                        if (this.cPppProcess != null) continue;
                        mRc = this.cPppRc;
                        break block10;
                    } while (System.currentTimeMillis() - timestamp <= 300000L);
                    this.stop();
                    mRc = 300;
                }
                catch (Exception e) {
                    this.logInfoError("Exception occurred during ppp.", e);
                }
            }
        }
        this.ttrace("<-- start() [" + mRc + "]");
        return mRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.cPppLock;
        synchronized (object) {
            if (this.cPppProcess != null) {
                this.cPppProcess.destroy();
            }
            try {
                RootProcess.executeProgram("rcsPppControl --kill " + this.cLinkname);
            }
            catch (Exception e) {
                this.logInfoError("Failed to execute rcsPppControl for killing.", e);
            }
            RcsPppControl.removeUniqueId(this.cLinkname);
            this.cPppActive = false;
        }
    }

    public boolean isActive() {
        return this.cPppActive;
    }

    public int getAuthType() {
        return this.cAuthType;
    }

    public void setAuthType(int pAuthType) {
        if (pAuthType != 1) {
            pAuthType = 0;
        }
        this.cAuthType = pAuthType;
    }

    public String getUsername() {
        return this.cUsername;
    }

    public void setUsername(String pUsername) {
        this.cUsername = pUsername;
    }

    public String getPassword() {
        return this.cPassword;
    }

    public void setPassword(String pPassword) {
        this.cPassword = pPassword;
    }

    public String getOptions() {
        return this.cOptions;
    }

    public void setOptions(String pOptions) {
        this.cOptions = pOptions;
    }
}

